clear all

* Set Folder to input one

cd ..\Inputs

* Import and clean oil data from Baumeister

import excel "oil - Christiane Baumeister - AEJ Macro 2013.xlsx", ///
sheet("oil monthly") cellrange(A1) firstrow clear
capture drop H

* Generate date related variables

drop if year==.
gen t=_n
tsset t
gen time=year+(month-1)/12

* Generate variables for regression

gen roilp=log(RefinerAcquisitionCostimport/USCPI)
gen dprod=log(WorldProduction/l.WorldProduction)

* Do regression and generate oil shocks

reg roilp l(1/12).roilp l(1/12).dprod l(1/12).IGEA
predict OILK, resid

gen     quarter=1 if month==1  | month==2  | month==3
replace quarter=2 if month==4  | month==5  | month==6
replace quarter=3 if month==7  | month==8  | month==9
replace quarter=4 if month==10 | month==11 | month==12

save tempOILK, replace

* Import oil supply shocks from Baumeister Hamilton

import excel "BH oil supply shock.xlsx", ///
cellrange(A1) firstrow clear

replace Time=Time+0.0001
gen year=int(Time)
bys year: gen month=_n
replace month=month+1 if year==1975 

* Merge both oil databases

merge 1:1 year month using tempOILK
drop Time _merge
sort year month
order OILBH, after(OILK)

summ OILBH
replace OILBH=(OILBH-`r(mean)')/`r(sd)'
summ OILK
replace OILBH=OILBH*`r(sd)'

* Collapse

collapse (sum) OILK OILBH (mean) roilp, by(year quarter)
label var OILK "Kilian (AER 2009) oil supply shock with Index of global economic activity"
label var OILBH "Baumeister and Hamilton (2015) oil supply shock"
label var roilp "Real price of oil"

replace OILBH=. if OILBH==0
gen time=year+(quarter-1)/4

* Delete temporary database

erase tempOILK.dta 

* Change to output folder and save

cd ..\Outputs
save OILK, replace
